# 模型训练不稳定

GAN训练不稳定的**原因**如下：

- 不收敛：很难使两个模型G和D同时收敛；
- 模式崩溃：生成器G生成单个或有限模式(4.2节详细介绍)；
- 慢速训练：生成器G的梯度消失。

训练GAN的时候，可以采取以下**训练技巧：**

1）生成器最后一层的激活函数用tanh()，输出归一化至[-1, 1]；

2）真实图像也归一化到[-1,1]之间；

3）学习率不要设置太大，初始1e-4可以参考，另外可以随着训练进行不断缩小学习率；

4）优化器尽量选择Adam，因为SGD解决的是一个寻找最小值的问题，GAN是一个博弈问题，使用SGD容易震荡；

5）避免使用ReLU和MaxPool，减少稀疏梯度的可能性，可以使用Leak Re LU激活函数，下采样可以用Average Pooling或者Convolution + stride替代。上采样可以用PixelShuffle, ConvTranspose2d + stride；

6）加噪声：在真实图像和生成图像中添加噪声，增加鉴别器训练难度，有利于提升稳定性；

7）如果有标签数据，尽量使用标签信息来训练；

8）标签平滑：如果真实图像的标签设置为1，我们将它更改为一个较低的值，比如0.9，避免鉴别器对其分类过于自信 。

